import logging
import json
import configparser
from os.path import exists
import os
from rttkpkg import logger as rttklogger
from dataclasses import dataclass
from cryptography.fernet import Fernet
log = logging.getLogger(rttklogger.LoggerName('Config'))
rttkcfgloaded = False

if os.getenv('RTTKPYRUNTYPE') == "SHELL":
    from rttkpkg import caddiestub as proxcs
if os.getenv('RTTKPYRUNTYPE') == "CADDIE":
    import caddieproxy as proxcs


@dataclass
class SSH_host:
    Alias : str = 'unset'
    HostName : str = 'unset'
    UserName : str = 'unset'
    #Password : str = 'unset'
    UseAgent : bool = True
    Enabled : bool = True

class Encrypt_Worker:

    def __init__(self, keyfile):
        self.__keyfile = keyfile

    def genewrite_key(self):
        self.__key = Fernet.generate_key()
        log.debug('Key generated:{}'.format(self.__key))
        with open(self.__keyfile,"wb") as key_file:
            key_file.write(self.__key)

    def get_key(self):
        try:
            self.__key= open(self.__keyfile,"rb").read()
            log.debug('Key retrieved:{}'.format(self.KeyLogString()))
        except Exception as e:
            log.critical("Error reading key from file {}".format(self.__keyfile))

    def Init_Worker(self):
        if exists(self.__keyfile):
            self.get_key()
        else:
            self.genewrite_key()
        self.eng = Fernet(self.__key)

    def KeyLogString(self):
        return ('len={}'.format(len(self.__key)) + ' Starts with{}'.format(self.__key[0:5]) + ' Ends with{}'.format(self.__key[-5:]))

    def test_enc(self):
        msg = "Message to ENCRYPT"
        text = msg.encode()
        encrypted_msg= self.eng.encrypt(text)
        log.debug('Encrypted Message = {}'.format(encrypted_msg))
        emu = encrypted_msg.decode()
        log.debug('Message as string = {}'.format(emu) )
        eme = emu.encode()
        log.debug('Message backbytes = {}'.format(eme) )
        decoded_text = self.eng.decrypt(eme)
        log.debug('Decoded Message = {}'.format(decoded_text))

    def PasswordEnc(self, clearpass):
        try:
            eb = self.eng.encrypt(clearpass.encode())
            ed = eb.decode('utf-8')
            return ed
        except Exception as e:
            log.critical("Exception in Encryption {}".format(e))

    def PasswordDec(self, encpass):
        log.info('EncPass = {}'.format(encpass))
        try:
            ep = encpass.encode('utf-8')
            rv = self.eng.decrypt(ep)
            et = rv.decode('utf-8')
            #log.debug('decPass = {}'.format(et))
            return et
        except Exception as e:
            log.critical("Exception in Decryption {}".format(e))

class Hosts_Worker:

    def __init__(self, configfile):
        self.__cfgfile = configfile
        self.__jsonConfig = None
        self.InitCfg()

    def IsValid(self):
        if exists(self.__cfgfile):
            log.debug('Config file exists : {}'.format(self.__cfgfile))
            return True
        else:
            log.critical('Config file not found : {}'.format(self.__cfgfile))
            return False

    def LoadCfg(self):
        try:
            with open(self.__cfgfile, "r") as jsonfile:
                self.__jsonConfig = json.load(jsonfile)
                jsonfile.close()
        except Exception as e:
            log.critical('error loading Json{}'.format(e))

    def SaveCfg(self):
        try:
            with open(self.__cfgfile, "w") as jsonfile:
                json.dump(self.__jsonConfig, jsonfile)
                jsonfile.close()
            log.info('Configuration Saved')
        except Exception as e:
            log.critical('error saving Json{}'.format(e))

    def CreateEmptyConfig(self):
        self.__jsonConfig = dict.fromkeys([self.StrSSHHosts(), self.StrAdbHosts()])
        self.__jsonConfig[self.StrSSHHosts()] = dict()
        self.__jsonConfig[self.StrAdbHosts()] = dict()
        log.debug('Saving Empty configuration')
        self.SaveCfg()

    def InitCfg(self):
        if self.IsValid():
            log.debug('Config file found attemping load')
            self.LoadCfg()
        else:
            log.critical('Config file not found, creating an empty configuration')
            self.CreateEmptyConfig()

    def HostsSSH(self):
        return self.__jsonConfig[self.StrSSHHosts()]

    def HostFromEntry(self, hostentry):
        try:
            he = SSH_host(hostentry['alias'], hostentry['host'], hostentry['user'], hostentry['useAgent'], hostentry['enabled'])
            #log.info('Host retrieved {}'.format(he))
            #he.Password = encwkr.PasswordDec( hostentry['passEnc'])
            #log.info('Host decrypted {}'.format(he))
            return he
        except Exception as e:
            log.critical('Error creating host class {}'.format(e))
            raise ValueError('Error reading class data from entry:{}'.format(hostentry))

    def AddHostSSH(self, alias, hostname, username, useAgent, enabled):
        hl = self.HostsSSH()
        if alias in hl:
            log.critical('Duplicate attempting to add alias: {}'.format(alias))
        else:
            try:
                he = SSH_host(alias, hostname, username, useAgent, enabled)
                log.info('Adding SSH host to dictionary {}'.format(he))
                hl[alias] = dict([('alias', hostname), ('host', hostname),('user', username), ('useAgent', useAgent), ('enabled', enabled)])
                #hl[alias] = dict([('alias', hostname), ('host', hostname),('user', username),('passEnc', encwkr.PasswordEnc(he.Password)), ('useAgent', hostname), ('enabled', enabled)])
                self.SaveCfg()
            except Exception as e:
                log.critical('Could not add host to list. error = {}'.format(e))

    def HostByAlias(self, alias):
        hl = self.HostsSSH()
        if alias in hl:
            try:
                hle = hl[alias]
                hbn = self.HostFromEntry(hle)
                return hbn
            except Exception as e:
                log.critical('Could not read host from dict {}'.format(e))
        else:
            log.critical('Host not found {}'.format(hostname))

    def UpdateByAlias(self, alias, hostname, username, useAgent, enabled):
        try:
            he = self.HostByAlias(alias)
            if he is None:
                log.critical('Alias not found {}'.format(alias))
            else:
                hl = self.HostsSSH()
                #hl[alias] = dict([('alias', alias), ('host', hostname),('user', username),('passEnc', encwkr.PasswordEnc(he.Password)), ('useAgent', hostname), ('enabled', enabled)])
                hl[alias] = dict([('alias', alias), ('host', hostname),('user', username), ('useAgent', useAgent), ('enabled', enabled)])
                self.SaveCfg()
                proxcs.HostConfigUpdated(he.Alias, he.HostName, he.UserName, he.UseAgent, he.Enabled)
        except Exception as e:
            log.critical('Failed in updating host: {}'.format(e))

    def DeleteByAlias(self, alias):
        hl = self.HostsSSH()
        try:
            if alias in hl:
                del hl[alias]
                log.info('Alias : {}  removed from host list'.format(alias))
                self.SaveCfg()
            else:
                log.info('Alias : {}  not found in host list'.format(alias))
        except Exception as e:
            log.critical('Failed in deleting host: {}'.format(e))




    def StrAdbHosts(self):
        return ('AdbHosts')

    def StrSSHHosts(self):
        return ('SSHHosts')

class RttkPyIni():

    def __init__(self, pyinifile):
        self.__pyinifile = pyinifile
        self.__rttkdatadir = os.path.dirname(pyinifile)
        self.__rtsn = 'RTTK_HOSTS'
        self.__rtpnkf = 'KeyFile'
        self.__rtpnhf = 'HostsFile'

    def CreatePyIni(self):
        cfgini = configparser.ConfigParser()
        cfgini.add_section(sn)
        cfgini.set(self.__rtsn, self.__rtpnkf, os.path.join(self.__rttkdatadir, 'pypass.key'))
        cfgini.set(self.__rtsn, self.__rtpnhf, os.path.join(self.__rttkdatadir,'pyrttkhosts.json'))
        with open(self.__pyinifile, 'w') as configfile:
            cfgini.write(configfile)

    @property
    def HostsFile(self):
        return self.__hostsFile

    @property
    def KeyFile(self):
        return self.__keyFile

    def LoadPyIni(self):
        if exists(self.__pyinifile) :
            cfgini = configparser.ConfigParser()
            cfgini.read(self.__pyinifile)
            if self.__rtsn in cfgini:
                #get the key file
                if self.__rtpnkf in cfgini[self.__rtsn]:
                    self.__keyFile = cfgini[self.__rtsn][self.__rtpnkf]
                else:
                    log.warn('key file entry not in ini file')
                #get the hosts file
                if self.__rtpnhf in cfgini[self.__rtsn]:
                    self.__hostsFile = cfgini[self.__rtsn][self.__rtpnhf]
                else:
                    log.warn('key file entry not in ini file')
            else:
                log.warn('Section [{}]not found in ini file'.format(self.__rtsn))
        else:
            log.critical('Ini file not found, unable to load {}'.format(self.__pyinifile))

def InitEncWorker():
    global encwkr
    try:
        encwkr = Encrypt_Worker(rkpyini.KeyFile)
        encwkr.Init_Worker()
        return True;
    except Exception as e:
        log.critical('Error initializing encryption {}'.format(e))
        return False

def ListHosts():
    try:
        for k,v in rttkcfg.HostsSSH().items():
            log.debug('host from key ={}'.format(k))
            he = rttkcfg.HostFromEntry(v)
            log.debug('host = {}'.format(he.HostName) + ' user={}'.format(he.UserName))
            proxcs.HostConfigFound(he.Alias, he.HostName, he.UserName, he.UseAgent, he.Enabled)
        return True
    except Exception as e:
        log.critical('Error Listing hosts {}'.format(e))
        return False

def InitIniFromEvn():
    global rkpyini
    try:
        ini = os.getenv('RTTKPYINIFILE')
        if ini == None:
            log.critical('environment variable RTTKPYINIFILE not set')
            return False
        else:
            log.debug('confguration loading from {}'.format(ini))
            rkpyini = RttkPyIni(ini)
            rkpyini.LoadPyIni()
            return True
    except Exception as e:
        log.debug('error in configure from env {}'.format(e))
        return False

def InitHostsFromIni():
    global rttkcfg
    try:
        rttkcfg = Hosts_Worker(rkpyini.HostsFile)
        return True
    except Exception as e:
        log.critical('Hosts not loaded {}'.format(e))
        return False

def load_rttk_config():
    log.debug('Loading config')
    try:
        InitIniFromEvn()
        InitHostsFromIni()
        InitEncWorker()
        encwkr.test_enc()
        rttkcfg.AddHostSSH('hn2', 'un', 'pw')
        #log.info(json.dumps(rttkcfg))
        rttkcfg.SaveCfg()
        rttkcfg.LoadCfg()
        #log.info(json.dumps(rttkcfg))
        hr = rttkcfg.HostByName('hn')
        log.debug('ret cred = {}'.format(hr))
    except Exception as e:
        log.error('Error loading config {}'.format(e))

def ConfigureByImport():
    global rttkcfgloaded
    try:
        log.debug('loading configuration via import')
        initStat = True;
        log.debug('Initstat = {}'.format(initStat))
        ss = InitIniFromEvn()
        log.debug ("stepstat = {}".format(ss))
        initStat = initStat and ss
        log.debug('Initstat = {}'.format(initStat))
        ss = InitHostsFromIni()
        log.debug ("stepstat = {}".format(ss))
        initStat = initStat and ss
        log.debug('Initstat = {}'.format(initStat))
        ss = InitEncWorker()
        log.debug ("stepstat = {}".format(ss))
        initStat = initStat and ss
        log.debug('Initstat = {}'.format(initStat))
        rttkcfgloaded = initStat
        log.debug('Done with load configuration via import. Status = {}'.format(rttkcfgloaded))
    except Exception as e:
        log.critical('Error loading config as import :{}'.format(e))

if __name__ == "__main__":
    rttkloger.RunAsScript()
    load_rttk_config()
else:
    ConfigureByImport()
