import zipfile
import zlib
import json
import argparse
import numpy as np

from os.path import exists
import logging
from rttkpkg import logger as rttkloger
log = logging.getLogger(rttkloger.LoggerName('Session'))

def FileExists(SessionFile):
    if exists(SessionFile):
        return True
    else:
        return False

class RttkSession:
    #constructor
    def __init__(self, sessionfile):
        self.SessionFile = sessionfile
        if self.IsValid():
            log.debug('session is valid')
        else:
            log.critical('not a valid session')

    #destructor
    def __del__(self):
        self.UnMountSession
        log.info('Session is destroyed')

    @property
    def SessionFile(self):
        return self.__sessionFile

    @SessionFile.setter
    def SessionFile(self, val):
        if FileExists(val):
            self.__sessionFile = val
        else:
            log.critical('Session does not exist : {}'.format(val))
            raise ValueError('File does not exist{}'.format(val))

    @property
    def StepInfos(self):
        return self.__stepInfos

    def FileExistsInSession(self, fileName):
        try:
            self.__zf.getinfo(fileName)
            log.debug('File Exists {}'.format(fileName))
            return(True)
        except KeyError:
            log.info('File not found {}'.format(fileName))
            return(False)

    @classmethod
    def StepFileName(self, stepguid ):
        return ("Step/"+stepguid)

    @classmethod
    def BitmapFileName(self, bmguid):
        return ("BM/"+ bmguid+'.png')

    def GetFileFromSession(self, filename):
        try:
            return self.__zf.read(filename)
        except:
            log.critical('Failed to read file {}'.format(filename))

    def StepDetail(self, stepguid):
        sfn = self.StepFileName(stepguid)
        if self.FileExistsInSession(sfn):
            sfj = self.GetFileFromSession(sfn)
            return sfj
        else:
            log.error('file not in session {}'.format(sfn))
            #should raise an error

    def GetBitmap(self, bmguid):
        bmn = self.BitmapFileName(bmguid)
        if self.FileExistsInSession(bmn):
            bmf  = self.__zf.read(bmn)
            return bmf
        else:
            log.error('Bitmap not found {}'.format(bmn))

    def AddFileToSession(self, filename, filecontent):
        if self.FileExistsInSession(filename):
            log.critical('File already exists, skipping addition')
        else:
            self.__zf.writestr(filename, json.dumps(filecontent),zipfile.ZIP_DEFLATED)
            log.debug('Added file to session {}'.format(filename))

    def IsValid(self):
        if exists(self.SessionFile):
            if zipfile.is_zipfile(self.SessionFile):
                return True
            else:
                log.info('Session file not in zip format : {}'.format(self.SessionFile))
                return False
        else:
            log.info('Session file not found : {}'.format(self.SessionFile))
            return False

    def LoadManifest(self):
        try:
            # this will throw key exception
            mi = self.__zf.getinfo("manifest.json")
            self.__manifest = json.loads(self.__zf.read("manifest.json"))
            log.debug('Manifest length = {}'.format(len(self.__manifest)))
            self.__stepInfos = self.__manifest["StepInfos"]
            log.debug('StepInfo length = {}'.format(len(self.__stepInfos)))
        except Exception as e:
            log.error('Unable to load manifest. error {}'.format(e))
            raise ValueError('Problem with manifest in{}'.format(val))

    def MountSession(self):
        if self.IsValid():
            try:
                self.__zf = zipfile.ZipFile(self.SessionFile, 'a' )
                self.LoadManifest()
            except:
                log.critical('Error loading manifest')
        else:
            log.info("Unable to mount session {}".format(self.SessionFile))


    def UnMountSession(self):
        try:
            self.__zf.close
            log.info('session unmounted')
        except:
            log.error('Failed unmounting session')

