import logging
import logging.handlers as lh
import os

ln = 'rttkpkg'
logger = logging.getLogger(ln)
logger.setLevel(logging.DEBUG)
formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')

def CreateFileHandler(pylognm):
    # create file handler which logs even debug messages
    fh = lh.RotatingFileHandler(pylognm, 'a', 10485760, 2)
    fh.setLevel(logging.DEBUG)
    fh.setFormatter(formatter)
    logger.addHandler(fh)
    logger.debug('rttk logging to file:{}'.format(pylognm))

def RunAsScript():
    ch = logging.StreamHandler()
    ch.setLevel(logging.DEBUG)
    ch.setFormatter(formatter)
    logger.addHandler(ch)
    logger.debug('rttk logging to console active')

def LoggerName(modulename):
    return (ln +'.' + modulename)

def SetLogFromEnv():
    #likely this needs a directory exist test
    try:
        logfl = os.getenv('RTTKPYLOGFILE')
        if logfl == None:
            logger.critical('environment variable RTTKPYLOGFILE not set')
        else:
            logger.debug('setting log file to {}'.format(logfl))
            CreateFileHandler(logfl)
    except Exception as e:
        logger.debug('error in configure from env {}'.format(e))

SetLogFromEnv()