import logging
from rttkpkg import logger as rttkloger
log = logging.getLogger(rttkloger.LoggerName('OSXGet'))

def collectsess(localdir, servername, username, password):
    from rttk import rttkssh as rs
    rs_util = rs.RTTK_SSH_Util()
    rs_util.ConfigureDirectories(localdir)
    rs_util.ConfigureHost(servername, username, password)
    cr = ''
    cn = rs_util.connect()
    ls = rs_util.connected()
    #rf = rttk_ssh.execute_command("pwsd 23", cr)
    #rf = rttk_ssh.execute_command("pwd", cr)
    print (rs_util.UserCacheDir())
    rs_util.UserRttkSessList()
    rs_util.disconnect()

def validateinstall():
    try:
        import paramiko
        log.debug('Paramiko imported')
        import argparse
        log.debug('ArgParse imported')
        import socket
        log.debug('Socket imported')
        import shutil
        log.debug('shutil imported')
        import os
        log.debug('os imported')
        import sys
        log.debug(sys.path)
    except ModuleNotFoundError as err:
        # Error handling
        log.critical(("error:{}").format(err))


if __name__ == "__main__":
    import argparse
    ap = argparse.ArgumentParser()
    ap.add_argument("-s", "--servername", required=True, help="OSX hostname")
    ap.add_argument("-u", "--username", required=True,	help="Username for OSX")
    ap.add_argument("-p", "--password", required=True,	help="Password for OSX")
    ap.add_argument("-ld", "--localdir", required=True, help="Local Directory to move files to")
    args = vars(ap.parse_args())
    collectsess(args["localdir"], args["servername"], args["username"], args["password"])
