import logging
from datetime import datetime
import time
import asyncio
from rttkpkg import logger as rttkloger
log = logging.getLogger(rttkloger.LoggerName('Validate'))

def printpath():
    import sys
    print('Sys path ={}'.format(sys.path))

def logpath():
    try:
        import sys
        log.debug('Sys path ={}'.format(sys.path))
        return True
    except  Exception as e:
        log.critical('Error in validate install :{}'.format(e))
        return False

def validateinstall():
    try:
        import stat
        log.debug('Stat imported')
        import paramiko
        log.debug('Paramiko imported')
        import argparse
        log.debug('ArgParse imported')
        import socket
        log.debug('Socket imported')
        import shutil
        log.debug('shutil imported')
        import os
        log.debug('os imported')
        import zipfile
        log.debug('ZipFile imported')
        import zlib
        log.debug('zlib imported')
        import json
        log.debug('Json Imported')
        import imutils
        log.debug('imutils imported')
        import numpy as np
        log.debug('numpy imported')
        import cv2
        log.debug('cv2 imported')
        import skimage.metrics
        log.debug('Structural similarity imported')
        return True
    except ModuleNotFoundError as err:
        # Error handling
        log.critical("Module not found Exception :{}".format(err))
        return False
    except  Exception as e:
        log.critical('Error in validate install :{}'.format(e))
        return False

async def SleepReply(SecToWait, HostMsg):
    log.debug('Start Waiting. HostMsg={} '.format(HostMsg) +' local time= {}'.format(datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f')) )
    await asyncio.sleep(SecToWait)
    log.debug('Done Waiting. HostMsg={} '.format(HostMsg)  +' local time= {}'.format(datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f')) )

def validatemodules():
    from rttkpkg.osxget import validateinstall as osxvi
    try:
        osxvi()
        log.debug('osxget required packages loaded')
    except Exception  as err:
        log.critical(("error:{}").format(err))
    from rttkpkg.screendiff import validateinstall as asvi
    try:
        asvi()
        log.debug('screen analysis required packages loaded')
    except Exception  as err:
        log.critical(("error:{}").format(err))

def LogMesg(msg):
    log.debug('Message from logmesg:{}'.format(msg))


if __name__ == "__main__":
    rttkloger.RunAsScript()
    LogMesg('Validation Starting')
    logpath()
    validateinstall()
    validatemodules()
    LogMesg('Validation Finished')